#include <iostream>
#include <vector>
#include <queue>

using namespace std;

class Node
{
public:
	int x, y, w, mode;
	Node(int x1, int y1, int w1, int mode1)
	{
		x = x1;
		y = y1;
		w = w1;
		mode = mode1;
	}
	Node()
	{
	}
};

class cmpr
{
public:
	bool operator()(Node& n1, Node& n2)
	{
		return (n1.w > n2.w);
	}
};
bool isAcc(int x, int y, int h, int w)
{
	if (x < 0 || y < 0 || x > h - 1 || y > w - 1) return false;
	return true;
}

int Dijkstra(vector<vector<char> > tabla, int h, int w)
{
	bool visited[h][w] = { 0 };
	queue<int> xs;
	queue<int> ys;
	int arr[] = { 0, -1, 1 };

	xs.push(0);
	ys.push(0);
	Node path[h][w];

	while (!xs.empty())
	{
		int x = xs.front();
		int y = ys.front();
		xs.pop();
		ys.pop();
	

		for (int i = 0; i < 3; ++i)
			for (int j = 0; j < 3; ++j)
			{
				int dx = arr[i];
				int dy = arr[j];

				dx += x;
				dy += y;

				if (!isAcc(dx, dy, h, w)) continue;
				if (visited[dx][dy]) continue;
				if (tabla[dx][dy] == '#') continue;

				visited[dx][dy] = true;
				xs.push(dx);
				ys.push(dy);
				path[dx][dy] =  Node(x, y, 0, 0);
			}
	}
	int i = h - 1;
	int j = w - 1;
	int sum = 0;
	while (i != 0 || j != 0)
	{
		++sum;
		Node n = path[i][j];
		i = n.x;
		j = n.y;
	}
	return sum;
}




int main()
{
	ios_base::sync_with_stdio(false);
	cin.tie(0);
	int h, w;
	cin >> h >> w;
	vector<vector<char> > tabla;
	for (int i = 0; i < h; ++i)
	{
		vector<char> input;
		for (int j = 0; j < w; ++j)
		{
			char temp;
			cin >> temp;
			input.push_back(temp);
		}
		tabla.push_back(input);
	}

	cout<< Dijkstra(tabla, h, w) << endl;
}